package org.matrix.database.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * TestData.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/2/21 at 5:06 PM
 * Suffering is the most powerful teacher of life.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("kt_test_data")
@ApiModel(value = "TestData对象", description = "测试用例用到的数据组")
public class TestData extends BaseEntity {

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("是否进行异常检验,0为否,1为是")
    private Integer abnormalCheckpoint = 0;

    @ApiModelProperty("是否进行非空检验,0为否,1为是")
    private Integer noEmptyCheckpoint = 0;

    @ApiModelProperty("包含某字段检验（例如 张三,李四） 则对检查结果中是否包含张三或者李四")
    private String containCheckpoint;

    @ApiModelProperty("不包含某字段检验（例如 张三,李四） 则对检查结果中是否不包含张三或者李四")
    private String noContainCheckpoint;

    @ApiModelProperty("数据库检验点，以JSON形式存放")
    private String databaseCheckpoint;

    @ApiModelProperty("jsonpath检验点，以json形式存放")
    private String jsonpathCheckpoint;

    @ApiModelProperty("详情参数")
    private String detail;

    @ApiModelProperty("数据组绑定的测试用例的主键id")
    private Long testCaseId;
}
