package org.matrix.database.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.database.entity.DynamicVariable;
import org.matrix.database.mapper.DynamicVariableMapper;
import org.matrix.database.service.IDynamicVariableService;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Service
public class DynamicVariableServiceImpl extends ServiceImpl<DynamicVariableMapper, DynamicVariable> implements IDynamicVariableService {

    private final DynamicVariableMapper mapper;

    public DynamicVariableServiceImpl(DynamicVariableMapper dynamicVariableMapper) {
        this.mapper = dynamicVariableMapper;
    }

    /**
     * 根据变量名称获取变量
     *
     * @param name      变量名
     * @param projectId 项目id
     * @return 变量
     */
    @Override
    public Optional<DynamicVariable> getByName(String name, Long projectId) {
        return Optional.ofNullable(mapper.selectOne(Wrappers.lambdaUpdate(DynamicVariable.class)
                .eq(DynamicVariable::getName, name)
                .eq(DynamicVariable::getProjectId, projectId)));
    }
}
