package org.matrix.remote.task;

import lombok.extern.slf4j.Slf4j;
import org.matrix.remote.service.DataAllCollector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 定时任务
 */
@Slf4j
@Component
public class DataCollectorTask implements CommandLineRunner {


    @Autowired
    private DataAllCollector dataAllCollector;

    /**
     * 同步禅道取的用户和项目数据
     * 每小时收集一次
     */
    @Scheduled(cron = "0 0 */1 * * ?")
    public void collect() {
        log.info("同步禅道用户项目数据...");
        dataAllCollector.execute();
        log.info("同步结束....");
    }

    @Override
    public void run(String... args) {
    }

}
