package org.matrix.database.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Swagger中的参数信息
 *
 * @author mry
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "参数信息")
public class Parameter {

    /**
     * 名称
     */
    @ApiModelProperty(value = "参数名称")
    private String name;

    /**
     * 类型
     */
    @ApiModelProperty(value = "参数类型")
    private String type;

    /**
     * in
     */
    @ApiModelProperty(value = "in")
    private String in;

}
