package org.matrix.database.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Select;
import org.matrix.database.entity.ExecutionHistory;
import org.matrix.database.vo.ExecutionHistoryVo;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author mry
 * @since 2022-03-11
 */
@Repository
public interface ExecutionHistoryMapper extends BaseMapper<ExecutionHistory> {

    /**
     * 根据CaseId和JobId 查询对应的数据列表
     * @param page 分页数据
     * @param jobId 测试任务ID
     * @param caseId 用例ID
     * @return 执行记录列表
     */
    @Select("<script>" +
            "SELECT\n" +
            "\tkeh.id,\n" +
            "\tkeh.union_key unionKey,\n" +
            "\tkeh.case_id caseId,\n" +
            "\tkeh.data_id dataId,\n" +
            "\tkeh.job_id jobId,\n" +
            "\tIF(MIN(keh.`status`)=0,0,MAX(keh.`status`)) `status`,\n" +
            "\tktc.`name` caseName,\n" +
            "\tktd.`name` dataName," +
            "\tMIN(keh.create_time) startTime,\n" +
            "\tMAX(keh.update_time) endTime " +
            "FROM\n" +
            "\tkt_execution_history keh\n" +
            "\tLEFT JOIN kt_test_case ktc ON ktc.id = keh.case_id\n" +
            "\tLEFT JOIN kt_test_data ktd ON ktd.id = keh.data_id" +
            "<where>" +
            "<if test=\"caseId!=null\">\n" +
            "and keh.case_id= #{caseId} \n" +
            " </if>" +
            "<if test=\"jobId!=null\">\n" +
            "and keh.job_id= #{jobId} \n" +
            " </if>" +
            "</where>" +
            "GROUP BY keh.union_key " +
            "</script>")
    IPage<ExecutionHistoryVo> pageByCaseIdAndJobId(IPage<ExecutionHistoryVo> page, Long caseId, Long jobId);

}
