package org.matrix.database.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.database.entity.ExecutionHistory;
import org.matrix.database.mapper.ExecutionHistoryMapper;
import org.matrix.database.service.IExecutionHistoryService;
import org.matrix.database.vo.ExecutionHistoryVo;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-03-11
 */
@Service
public class ExecutionHistoryServiceImpl extends ServiceImpl<ExecutionHistoryMapper, ExecutionHistory> implements IExecutionHistoryService {

    @Override
    public IPage<ExecutionHistoryVo> pageExecutionHistoryVoByCaseIdAndJobId(Long caseId, Long jobId, int pageNum, int pageSize ) {
        Page<ExecutionHistoryVo> page = new Page<>(pageNum, pageSize);
        return baseMapper.pageByCaseIdAndJobId(page,caseId,jobId);
    }
}
