package org.matrix.socket;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 用例日志临时存储对象
 * @author huangxiahao
 */
@Data
public class TestExecuteLog {


    private Long testJobId = -1L;
    /**
     * 用于记录执行记录的唯一KEY，同一批次的执行记录应该具有相同的KEY。
     */
    private String unionKey;

    private TestExecuteType type = TestExecuteType.TEST_CASE;

    private Long userId = -1L ;

    private Long testCaseId = -1L;

    private Long testDataId = -1L;

    private List<String> log = new ArrayList<>();


    /**
     * 前置条件：每个用例下的数据组是单线程执行的
     * 由于arrayList是有序的,所以只需要向下新增就好了
     */
    public void addLog(String log){
        this.log.add(log);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestExecuteLog)) {
            return false;
        }
        TestExecuteLog that = (TestExecuteLog) o;
        return getType() == that.getType() && Objects.equals(getUserId(), that.getUserId()) && Objects.equals(getTestCaseId(), that.getTestCaseId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getType(), getUserId(), getTestCaseId());
    }
}
