package org.matrix.actuators.move;

import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.matrix.socket.LogQueueRuntime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

/**
 * MoveActuatorTest.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/3/9 at 3:59 PM
 * Suffering is the most powerful teacher of life.
 */
@RunWith(SpringRunner.class)
@SpringBootTest
class MoveActuatorTest {

    @Autowired
    private MoveActuator moveActuator;

    @Test
    void runMoveSQL() {
        LogQueueRuntime.initTestCaseLog(null,null, null, null, null);
        moveActuator.runMove(72L, 9L, 1L, null, MoveStrategy.PRE_MOVE);
        String result = moveActuator.parseMoveVar("${pre72.url}[1]");
        Assertions.assertTrue(result.length() > 0, result);
    }

    @Test
    void runMoveHTTP() {
        LogQueueRuntime.initTestCaseLog(null,null, null, null, null);
        moveActuator.runMove(72L, 10L, 1L, null, MoveStrategy.PRE_MOVE);
        String result = moveActuator.parseMoveVar("${pre72.responseBody}<$.data.records[1].name>");
        Assertions.assertTrue(result.length() > 0, result);
    }

}