package org.matrix;

import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * Hello world!
 *
 * @author matrix
 */
@Slf4j
@EnableScheduling
@SpringBootApplication
@EntityScan(basePackages = {"org.matrix.remote.entity","org.matrix.local.entity"})
@MapperScan(basePackages = {"org.matrix.remote.mapper","org.matrix.local.mapper"})
public class ZentaoApplication {

    public static void main(String[] args) {
        SpringApplication.run(ZentaoApplication.class, args);
    }

}
