package org.matrix.autotest.config;

import com.google.common.base.Predicates;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * @author mry
 */
@Configuration
@EnableSwagger2
public class SwaggerConfigApi {

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                //将api的单元信息者只为包含在json ResourceListing响应中。
                .apiInfo(apiInfo())
                //选择哪些接口作为swagger的doc发布
                .select()
                //不显示错误的接口地址
                .paths(Predicates.not(PathSelectors.regex("/error.*")))
                .paths(PathSelectors.any())
                .build();
    }

    public ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                //标题
                .title("自动测试系统")
                //简介
                .description("自动测试系统接口文档")
                //版本
                .version("1.0")
                .build();
    }

}
