package org.matrix.autotest.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.*;
import org.matrix.database.service.IExecutionHistoryService;
import org.matrix.database.vo.CommonResult;
import org.matrix.database.vo.CommonResultObj;
import org.matrix.database.vo.ExecutionHistoryVo;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author hxh
 */
@CrossOrigin
@RestController
@RequestMapping("/executionHistory")
@Api(tags = "对执行历史execution_history的基本操作")
public class ExecutionHistoryController {

    private final IExecutionHistoryService executionHistoryService;

    public ExecutionHistoryController(IExecutionHistoryService executionHistoryService) {
        this.executionHistoryService = executionHistoryService;
    }

    @ApiOperation(value = "分页查询执行历史",notes = "假如查询测试用例的执行历史，请入参caseId，假如查询测试任务的执行历史，请入参jobId")
    @GetMapping("/findExecutionHistory")
    @ApiImplicitParams({
            @ApiImplicitParam(name="pageSize",value="页码",required=true,paramType="query"),
            @ApiImplicitParam(name="pageNum",value="当前页显示调试",required=true,paramType="query"),
            @ApiImplicitParam(name="jobId",value="测试任务ID",paramType="query"),
            @ApiImplicitParam(name="caseId",value="测试用例ID",paramType="query")
    })
    public  ResponseEntity<CommonResultObj<IPage<ExecutionHistoryVo>>> findExecutionHistory(
                         @RequestParam(defaultValue = "10")  int pageSize,
                         @RequestParam(defaultValue = "1") int pageNum,
                         @RequestParam(defaultValue = "-1") Long jobId,
                         Long caseId
                         ){
        IPage<ExecutionHistoryVo> page = executionHistoryService.pageExecutionHistoryVoByCaseIdAndJobId(caseId, jobId, pageNum, pageSize);
        return page.getRecords().size() != 0
                ? CommonResult.success(page, "查询成功")
                : CommonResult.failed(page, "查询失败或无数据");
    }
}
