package org.matrix.autotest.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.matrix.autotest.entity.Connect;
import org.matrix.autotest.service.ConnectService;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@RestController
@RequestMapping("/connects")
@Api(tags = "对连接池表connect的基本操作")
public class ConnectController {

    private final ConnectService connectService;

    public ConnectController(ConnectService connectService) {
        this.connectService = connectService;
    }

    /**
     * 查询所有连接池
     *
     * @return 连接池
     */
    @ApiOperation(value = "查询所有连接池")
    @GetMapping
    public List<Connect> findAllConnect() {
        return connectService.findAllConnect();
    }

    /**
     * 根据id查询连接池
     *
     * @param id 连接池Id
     * @return 连接池
     */
    @ApiOperation(value = "根据id查询连接池")
    @GetMapping("/{id}")
    public Connect findByIdConnect(@PathVariable Integer id) {
        return connectService.findByIdConnect(id);
    }

    /**
     * 添加连接池
     *
     * @param connect 连接池
     * @return 添加的连接池
     */
    @ApiOperation(value = "添加连接池")
    @PostMapping
    public Connect insertConnect(@RequestBody Connect connect) {
        return connectService.insertConnect(connect);
    }

    /**
     * 修改连接池
     *
     * @param connect 连接池
     * @return 修改后的连接池
     */
    @ApiOperation(value = "根据id修改连接池")
    @PutMapping("/{id}")
    public Connect updateConnect(@RequestBody Connect connect) {
        return connectService.updateConnect(connect);
    }

    /**
     * 删除连接池
     *
     * @param connect 连接池
     * @return 删除的连接池
     */
    @ApiOperation(value = "根据id删除连接池")
    @DeleteMapping("/{id}")
    public Connect deleteConnect(@RequestBody Connect connect) {
        return connectService.deleteConnect(connect);
    }
}

