package org.matrix.autotest.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.matrix.autotest.entity.Environment;
import org.matrix.autotest.service.EnvironmentService;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 实例表，项目对应的环境实例，例如：实验室环境，开发环境等 前端控制器
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@RestController
@RequestMapping("/environments")
@Api(tags = "对实例表example的基本操作")
public class EnvironmentController {

    private final EnvironmentService environmentService;

    public EnvironmentController(EnvironmentService environmentService) {
        this.environmentService = environmentService;
    }

    /**
     * 查询所有实例
     *
     * @return 实例
     */
    @ApiOperation(value = "查询所有实例")
    @GetMapping
    public List<Environment> findAllEnvironment() {
        return environmentService.findAllEnvironment();
    }

    /**
     * 根据id查询实例
     *
     * @param id 实例Id
     * @return 实例
     */
    @ApiOperation(value = "根据id查询实例")
    @GetMapping("/{id}")
    public Environment findByIdEnvironment(@PathVariable Integer id) {
        return environmentService.findByIdEnvironment(id);
    }

    /**
     * 添加实例
     *
     * @param environment 实例
     * @return 添加的实例
     */
    @ApiOperation(value = "添加实例")
    @PostMapping
    public Environment insertEnvironment(@RequestBody Environment environment) {
        return environmentService.insertEnvironment(environment);
    }

    /**
     * 修改实例
     *
     * @param environment 实例
     * @return 修改后的实例
     */
    @ApiOperation(value = "根据id修改实例")
    @PutMapping("/{id}")
    public Environment updateEnvironment(@RequestBody Environment environment) {
        return environmentService.updateEnvironment(environment);
    }

    /**
     * 删除实例
     *
     * @param environment 实例
     * @return 删除的实例
     */
    @ApiOperation(value = "根据id删除实例")
    @DeleteMapping("/{id}")
    public Environment deleteEnvironment(@RequestBody Environment environment){
        return environmentService.deleteEnvironment(environment);
    }
}

