package org.matrix.autotest.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.matrix.autotest.entity.Move;
import org.matrix.autotest.service.MoveService;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@RestController
@RequestMapping("/moves")
@Api(tags = "对行为表move的基本操作")
public class MoveController {

    private final MoveService moveService;

    public MoveController(MoveService moveService) {
        this.moveService = moveService;
    }

    /**
     * 查询所有行为
     *
     * @return 行为
     */
    @ApiOperation(value = "查询所有行为")
    @GetMapping
    public List<Move> findAllMove() {
        return moveService.findAllMove();
    }

    /**
     * 根据id查询行为
     *
     * @param id 行为Id
     * @return 行为
     */
    @ApiOperation(value = "根据id查询行为")
    @GetMapping("/{id}")
    public Move findByIdMove(@PathVariable Integer id) {
        return moveService.findByIdMove(id);
    }

    /**
     * 添加行为
     *
     * @param move 行为
     * @return 添加的行为
     */
    @ApiOperation(value = "添加行为")
    @PostMapping
    public Move insertMove(@RequestBody Move move) {
        return moveService.insertMove(move);
    }

    /**
     * 修改行为
     *
     * @param move 行为
     * @return 修改后的行为
     */
    @ApiOperation(value = "根据id修改行为")
    @PutMapping("/{id}")
    public Move updateMove(@RequestBody Move move) {
        return moveService.updateMove(move);
    }

    /**
     * 删除行为
     *
     * @param move 行为
     * @return 删除的行为
     */
    @ApiOperation(value = "根据id删除行为")
    @DeleteMapping("/{id}")
    public Move deleteMove(@RequestBody Move move) {
        return moveService.deleteMove(move);
    }
}

