package org.matrix.autotest.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.matrix.autotest.entity.Project;
import org.matrix.autotest.service.ProjectService;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@RestController
@RequestMapping("/projects")
@Api(tags = "对项目表project的基本操作")
public class ProjectController {

    private final ProjectService projectService;

    public ProjectController(ProjectService projectService) {
        this.projectService = projectService;
    }

    /**
     * 查询所有项目
     *
     * @return 项目
     */
    @ApiOperation(value = "查询所有项目")
    @GetMapping
    public List<Project> findAllProject() {
        return projectService.findAllProject();
    }

    /**
     * 根据id查询项目
     *
     * @param id 项目Id
     * @return 项目
     */
    @ApiOperation(value = "根据id查询项目")
    @GetMapping("/{id}")
    public Project findByIdProject(@PathVariable Integer id) {
        return projectService.findByIdProject(id);
    }

    /**
     * 添加项目
     *
     * @param project 项目
     * @return 添加的项目
     */
    @ApiOperation(value = "添加项目")
    @PostMapping
    public Project insertProject(@RequestBody Project project) {
        return projectService.insertProject(project);
    }

    /**
     * 修改项目
     *
     * @param project 项目
     * @return 修改后的项目
     */
    @ApiOperation(value = "根据id修改项目")
    @PutMapping("/{id}")
    public Project updateProject(@RequestBody Project project) {
        return projectService.updateProject(project);
    }

    /**
     * 删除项目
     *
     * @param project 项目
     * @return 删除的项目
     */
    @ApiOperation(value = "根据id删除项目")
    @DeleteMapping("/{id}")
    public Project deleteProject(@RequestBody Project project) {
        return projectService.deleteProject(project);
    }
}

