package org.matrix.autotest.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.matrix.autotest.entity.TestCase;
import org.matrix.autotest.service.TestCaseService;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@RestController
@RequestMapping("/testCases")
@Api(tags = "对用例表test_case的基本操作")
public class TestCaseController {

    private final TestCaseService testCaseService;

    public TestCaseController(TestCaseService testCaseService) {
        this.testCaseService = testCaseService;
    }

    /**
     * 查询所有用例
     *
     * @return 用例
     */
    @ApiOperation(value = "查询所有用例")
    @GetMapping
    public List<TestCase> findAllTestCase() {
        return testCaseService.findAllTestCase();
    }

    /**
     * 根据id查询用例
     *
     * @param id 用例Id
     * @return 用例
     */
    @ApiOperation(value = "根据id查询用例")
    @GetMapping("/{id}")
    public TestCase findByIdTestCase(@PathVariable Integer id) {
        return testCaseService.findByIdTestCase(id);
    }

    /**
     * 添加用例
     *
     * @param testCase 用例
     * @return 添加的用例
     */
    @ApiOperation(value = "添加用例")
    @PostMapping
    public TestCase insertTestCase(@RequestBody TestCase testCase) {
        return testCaseService.insertTestCase(testCase);
    }

    /**
     * 修改用例
     *
     * @param testCase 用例
     * @return 修改后的用例
     */
    @ApiOperation(value = "根据id修改用例")
    @PutMapping("/{id}")
    public TestCase updateTestCase(@RequestBody TestCase testCase) {
        return testCaseService.updateTestCase(testCase);
    }

    /**
     * 删除用例
     *
     * @param testCase 用例
     * @return 删除的用例
     */
    @ApiOperation(value = "根据id删除用例")
    @DeleteMapping("/{id}")
    public TestCase deleteTestCase(@RequestBody TestCase testCase) {
        return testCaseService.deleteTestCase(testCase);
    }
}

