package org.matrix.autotest.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.autotest.entity.Action;

import java.util.List;

/**
 * <p>
 * 动作 服务类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
public interface ActionService extends IService<Action> {

    /**
     * 查询所有动作
     *
     * @return 查询到的所有动作
     */
    List<Action> findAllAction();

    /**
     * 根据id查询动作
     *
     * @param id 动作id
     * @return 动作
     */
    Action findByIdAction(Integer id);

    /**
     * 添加动作
     *
     * @param action 动作
     * @return 添加的动作
     */
    Action insertAction(Action action);

    /**
     * 修改动作
     *
     * @param action 动作
     * @return 修改后的动作
     */
    Action updateAction(Action action);

    /**
     * 删除动作
     *
     * @param action 动作
     * @return 删除的动作
     */
    Action deleteAction(Action action);

}
