package org.matrix.autotest.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.autotest.entity.DynamicVariable;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
public interface DynamicVariableService extends IService<DynamicVariable> {
    /**
     * 查询所有动态变量
     *
     * @return 动态变量
     */
    List<DynamicVariable> findAllDynamicVariable();

    /**
     * 根据id查询动态变量
     *
     * @param id 动态变量id
     * @return 动态变量
     */
    DynamicVariable findByIdDynamicVariable(Integer id);

    /**
     * 添加动态变量
     *
     * @param dynamicVariable 动态变量
     * @return 添加的动态变量
     */
    DynamicVariable insertDynamicVariable(DynamicVariable dynamicVariable);

    /**
     * 修改动态变量
     *
     * @param dynamicVariable 动态变量
     * @return 修改后的动态变量
     */
    DynamicVariable updateDynamicVariable(DynamicVariable dynamicVariable);

    /**
     * 删除动态变量
     *
     * @param dynamicVariable 动态变量
     * @return 删除的动态变量
     */
    DynamicVariable deleteDynamicVariable(DynamicVariable dynamicVariable);
}
