package org.matrix.autotest.service.Impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.autotest.dao.ActionMapper;
import org.matrix.autotest.entity.Action;
import org.matrix.autotest.service.ActionService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 动作 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@Service
public class ActionServiceImpl extends ServiceImpl<ActionMapper, Action> implements ActionService {

    private final ActionMapper actionMapper;

    public ActionServiceImpl(ActionMapper actionMapper) {
        this.actionMapper = actionMapper;
    }

    @Override
    public List<Action> findAllAction() {
        return actionMapper.selectList(null);
    }

    @Override
    public Action findByIdAction(Integer id) {
        return actionMapper.selectById(id);
    }

    @Override
    public Action insertAction(Action action) {
        actionMapper.insert(action);
        return action;
    }

    @Override
    public Action updateAction(Action action) {
        actionMapper.updateById(action);
        return action;
    }

    @Override
    public Action deleteAction(Action action) {
        actionMapper.deleteById(action.getId());
        return action;
    }

}
