package org.matrix.autotest.service.Impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.autotest.dao.ConnectMapper;
import org.matrix.autotest.entity.Connect;
import org.matrix.autotest.service.ConnectService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@Service
public class ConnectServiceImpl extends ServiceImpl<ConnectMapper, Connect> implements ConnectService {

    private final ConnectMapper connectMapper;

    public ConnectServiceImpl(ConnectMapper connectMapper) {
        this.connectMapper = connectMapper;
    }

    @Override
    public List<Connect> findAllConnect() {
        return connectMapper.selectList(null);
    }

    @Override
    public Connect findByIdConnect(Integer id) {
        return connectMapper.selectById(id);
    }

    @Override
    public Connect insertConnect(Connect connect) {
        connectMapper.insert(connect);
        return connect;
    }

    @Override
    public Connect updateConnect(Connect connect) {
        connectMapper.updateById(connect);
        return connect;
    }

    @Override
    public Connect deleteConnect(Connect connect) {
        connectMapper.deleteById(connect.getId());
        return connect;
    }

}
