package org.matrix.autotest.service.Impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.autotest.dao.ProjectMapper;
import org.matrix.autotest.entity.Project;
import org.matrix.autotest.service.ProjectService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@Service
public class ProjectServiceImpl extends ServiceImpl<ProjectMapper, Project> implements ProjectService {

    private final ProjectMapper projectMapper;

    public ProjectServiceImpl(ProjectMapper projectMapper) {
        this.projectMapper = projectMapper;
    }

    @Override
    public List<Project> findAllProject() {
        return projectMapper.selectList(null);
    }

    @Override
    public Project findByIdProject(Integer id) {
        return projectMapper.selectById(id);
    }

    @Override
    public Project insertProject(Project project) {
        projectMapper.insert(project);
        return project;
    }

    @Override
    public Project updateProject(Project project) {
        projectMapper.updateById(project);
        return project;
    }

    @Override
    public Project deleteProject(Project project) {
        projectMapper.deleteById(project.getId());
        return project;
    }
}
