package org.matrix.entity.httpRequest;

import java.util.HashMap;
import java.util.Map;

public enum MultiPartRequestBodyType {

    TEXT,
    FILE;

    private static final Map<String, MultiPartRequestBodyType> mappings = new HashMap(16);

    private MultiPartRequestBodyType() {
    }

    public static MultiPartRequestBodyType resolve( String method) {
        return method != null ? mappings.get(method) : null;
    }

    public boolean matches(String method) {
        return this.name().equals(method);
    }

    static {
        MultiPartRequestBodyType[] var0 = values();
        int var1 = var0.length;
        for(int var2 = 0; var2 < var1; ++var2) {
            MultiPartRequestBodyType httpMethod = var0[var2];
            mappings.put(httpMethod.name(), httpMethod);
        }

    }
}
