package org.matrix.database.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.database.entity.Connect;
import org.matrix.database.vo.PageResult;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
public interface IConnectService extends IService<Connect> {

    /**
     * 添加连接池
     *
     * @param connect 连接池
     * @return 影响行数
     */
    int insertConnect(Connect connect);

    /**
     * 修改连接池
     *
     * @param connect 连接池
     * @return 影响行数
     */
    int updateConnect(Connect connect);

    /**
     * 删除连接池
     *
     * @param id 连接池id
     * @return 影响行数
     */
    int deleteConnect(Integer id);

    /**
     * 分页查询
     *
     * @param pageResult 封装的分页
     * @return 分页后的数据
     */
    PageResult pageAll(PageResult pageResult);

}
