package org.matrix.database.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * <p>
 *
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("kt_test_case")
@ApiModel(value = "TestCase对象", description = "用例")
public class TestCase extends BaseEntity {

    @ApiModelProperty("名称")
    private String name;

    @ApiModelProperty("所属项目")
    private Long projectId;

    @ApiModelProperty("用例类型 1为http")
    private Integer type;

    @ApiModelProperty("详细参数")
    private String detail;

    @ApiModelProperty("前置行动ID组，例如：1，2，3")
    private String moveBefore;

    @ApiModelProperty("后置行动ID组，例如：1，2，3")
    private String moveAfterCase;

    @ApiModelProperty("测试执行后行动ID组，例如：1，2，3")
    private String moveAfterTest;

    @ApiModelProperty("用例描述")
    private String des;

}
