package org.matrix.actuators.sql;

import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;

import org.matrix.actuators.usecase.CaseActuator;
import org.matrix.actuators.usecase.TestCaseExecuteResult;
import org.matrix.database.entity.TestCase;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest
class CaseActuatorTest {


    @Test
    void test(){
        CaseActuator httpClientActuator = new CaseActuator(
                1l,
                1l
        );
        String json = "{\n" +
                "    \"url\":\"http://192.168.102.223:13245/test/sayHelloJson\",\n" +
                "    \"method\":\"POST\",\n" +
                "    \"requestType\":\"JSON\",\n" +
                "    \"stringValue\":\"{\\\"name\\\":\\\"${componentName}[0]\\\"}\",\n" +
                "    \"headers\":[\n" +
                "        {\n" +
                "            \"name\":\"cookie\",\n" +
                "            \"value\":\"123456\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";
        System.out.println(json);
        TestCase testCase = new TestCase();
        testCase.setName("name");
        testCase.setType(1);
        testCase.setDetail(json);
        testCase.setAbnormalCheckpoint(1);
        testCase.setContainCheckpoint("张三,李四");
        testCase.setNoContainCheckpoint("张三,李四");
        testCase.setJsonpathCheckpoint("contains({$..category},'${componentName}[0]')");

        TestCaseExecuteResult testCaseExecuteResult = httpClientActuator.executeTestCase(testCase);
        System.out.println(testCaseExecuteResult);


    }

}
