package org.matrix.database.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.database.entity.Project;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
public interface IProjectService extends IService<Project> {

    /**
     * 查询所有项目
     *
     * @return 查询到的所有项目
     */
    List<Project> findAllProject();

    /**
     * 添加项目
     *
     * @param project 项目
     * @return 影响行数
     */
    int insertProject(Project project);

    /**
     * 修改项目
     *
     * @param project 项目
     * @return 影响行数
     */
    int updateProject(Project project);

    /**
     * 删除项目
     *
     * @param id 项目id
     * @return 影响行数
     */
    int deleteProject(Integer id);

}
