package org.matrix.actuators.datasource;

import javax.sql.DataSource;
import java.sql.SQLException;
import java.util.Set;

/**
 * IDataSourceService.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2022/1/19 at 5:38 PM
 * Suffering is the most powerful teacher of life.
 */
public interface IDataSourceService {

    /**
     * 获得当前线程正在使用的数据源
     * @return 当前线程正在使用的数据源
     */
    DataSource peek();

    /**
     * 用于测试是否可以连接该目标数据源
     * @param dataSourceDTO 用于连接目标数据源的参数对象
     * @return 是否可以连通该数据源
     */
    boolean testConnection(DataSourceDTO dataSourceDTO) throws SQLException;


    /**
     * 切换回主数据源
     * @return 是否切换成功
     */
    boolean switchMainDataSource();

    /**
     * 将当前使用的数据替换为参数提供的数据源,如果还没有,则会添加,如果已经有了,则不会添加
     *
     * @param dto 数据源信息
     * @return 当前已经存在的数据源集合
     */
    @SuppressWarnings("UnusedReturnValue")
    Set<String> switchDataSource(DataSourceDTO dto);

    /**
     * 添加数据源,如果已经存在同名的数据源了,则不会添加
     *
     * @param dto 数据源信息
     * @return 数据源名称的集合, 用于 DynamicDataSourceContextHolder.push("数据源名称") 这样的代码中
     */
    Set<String> add(DataSourceDTO dto);

    /**
     * 添加数据源,如果已经存在同名的数据源了,则会覆盖
     *
     * @param dto 数据源信息
     * @return 数据源名称的集合, 用于 DynamicDataSourceContextHolder.push("数据源名称") 这样的代码中
     */
    Set<String> addAndUpdate(DataSourceDTO dto);

    /**
     * 获取当前所有数据源
     *
     * @return 数据源名称的集合, 用于 DynamicDataSourceContextHolder.push("数据源名称") 这样的代码中
     */
    Set<String> now();

    /**
     * 删除数据源
     *
     * @param name 数据源名称
     * @return 删除信息
     */
    public String remove(String name);


}
