package org.matrix.database.vo;

import lombok.Data;
import org.matrix.database.entity.ExecutionHistory;

import java.time.LocalDateTime;

/**
 * ExecutionHistory 给前端用于展示的VO
 * @author huangxiahao
 */
@Data
public class ExecutionHistoryVo extends ExecutionHistory {

    /**
     * 名称(case-caseName , job - jobName)
     */
    private String caseName;

    private String dataName;

    /**
     * caseId -> 这一条用例运行时的开始时间 startTime最小值
     * jobId -> 这一个测试任务的开始时间 startTime最小值
     */
    private LocalDateTime startTime;

    private LocalDateTime endTime;

    private String url;

}
