package org.matrix.actuators.checkpoint;

import cn.hutool.script.ScriptUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.matrix.actuators.Actuator;
import org.matrix.actuators.httpclient.HttpResponseDetail;
import org.matrix.exception.CheckPointException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;

import javax.script.ScriptEngine;
import javax.script.ScriptException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * 数据检测点工具
 * todo 打印LOG
 *
 * @author huangxiahao
 */
public class CheckPointActuator implements Actuator {

    private final String baseJs;

    private Long projectId;

    private Long envId;

    public CheckPointActuator(String baseJsPath, Long env, Long projectId) {
        ClassPathResource cpr = new ClassPathResource(baseJsPath);
        try {
            this.baseJs = IOUtils.toString(cpr.getInputStream(), StandardCharsets.UTF_8);
        } catch (IOException e) {
            throw new CheckPointException("初始JS加载失败");
        }
        this.projectId = projectId;
        this.envId = env;
    }

    public CheckPointResult httpCheck(HttpResponseDetail httpResponseDetail, CheckPoint checkPoint) {
        CheckPointResult checkPointResult = new CheckPointResult();
        //根据checkPoint里的细节数据开始检测
        //异常检查点检测
        if (checkPoint.getUseExceptionCheck()) {
            checkPointResult.addCheckPointResultDetail(exceptionCheck(httpResponseDetail));
        }
        //异常检查点检测
        if (checkPoint.getUseNullCheck()) {
            checkPointResult.addCheckPointResultDetail(nullCheck(httpResponseDetail.getResponseBody()));
        }
        //包含检查点检测
        checkPointResult.addCheckPointResultDetail(containCheck(checkPoint.getContainCheckPoints(), httpResponseDetail.getResponseBody()));
        //不包含检查点检测
        checkPointResult.addCheckPointResultDetail(noContainCheck(checkPoint.getNoContainCheckPoint(), httpResponseDetail.getResponseBody()));
        //JsonPath检查点检测
        if (checkPoint.getJsonPathCheckPoints().size() > 0) {
            Object jsonObject = Configuration.defaultConfiguration().jsonProvider().parse(httpResponseDetail.getResponseBody());
            for (JsonPathCheckPoint jsonPathCheckPoint : checkPoint.getJsonPathCheckPoints()) {
                checkPointResult.addCheckPointResultDetail(jsonPathCheck(jsonPathCheckPoint, jsonObject));
            }
        }
        return checkPointResult;
    }

    public CheckPointResultDetail jsonPathCheck(JsonPathCheckPoint jsonPathCheckPoint, Object jsonObject) {
        String expression;
        try {
            expression = completeJsonPathExpression(jsonPathCheckPoint, jsonObject);
        } catch (IllegalArgumentException e) {
            return new CheckPointResultDetail(
                    false,
                    String.format("JsonPath检查点，检查未通过，不能填写空的JsonPath,错误的jsonpath为：%s", jsonPathCheckPoint.getExpression())
            );
        } catch (PathNotFoundException e) {
            return new CheckPointResultDetail(
                    false,
                    String.format("JsonPath检查点，检查未通过，jsonpath取不到任何值，错误的path为：%s,http返回值为：  %s", e.getMessage().substring(e.getMessage().indexOf(":")), jsonObject.toString())
            );
        }
        try {
            ScriptEngine jsEngine = getScriptEngine();
            Object eval = jsEngine.eval(expression);
            if (eval instanceof Boolean){
                if ((Boolean) eval){
                    return new CheckPointResultDetail(
                            true,
                            String.format("JsonPath检查点，检查通过,表达式为：%s", expression)
                    );
                }else {
                    return new CheckPointResultDetail(
                            false,
                            String.format("JsonPath检查点，检查未通过,计算结果为false,错误的表达式为：%s", expression)
                    );
                }
            }else {
                return new CheckPointResultDetail(
                        false,
                        String.format("JsonPath检查点，检查未通过，JsonPath的返回值不是一个布尔类型,错误的表达式为：%s", expression)
                );
            }
        } catch (ScriptException e) {
            throw new CheckPointException("初始化js引擎失败");
        }
    }

    public ScriptEngine getScriptEngine() throws ScriptException {
        ScriptEngine jsEngine = ScriptUtil.createJsEngine();
        jsEngine.eval(baseJs);
        return jsEngine;
    }

    /**
     *
     * @param jsonObject 这个Object 是由  Configuration.defaultConfiguration().jsonProvider().parse(“json字符串”);  这个方法转换过来的 请不要乱传
     * @return
     */
    public String completeJsonPathExpression(JsonPathCheckPoint jsonPathCheckPoint, Object jsonObject) {
        String result = jsonPathCheckPoint.getExpression();
        //todo 李迪凡 先将result中的动态变量都还原出来  （先后顺序不能乱）得先还原动态变量

        //将jsonPath都还原出来
        String jsonPathRegex = "\\{(\\s)*\\$.*?}";
        result = regexExpression(result, jsonPathRegex, jsonObject, (o, s) -> JSON.toJSONString(JsonPath.read(o, s.substring(1, s.length() - 1))));
        return result;
    }

    public static String regexExpression(String expression, String regex,Object sourceContent, BiFunction<Object,String,String> biFunction){
        String result = expression;
        Pattern pattern = Pattern.compile(regex);
        Matcher mat = pattern.matcher(result);
        while (mat.find()) {
            String group = mat.group();
            String read = biFunction.apply(sourceContent,group);
            result = mat.replaceAll(read);
        }
        return result;
    }



    public CheckPointResultDetail containCheck(ContainCheckPoint containCheckPoint, String responseBody) {
        if (responseBody.contains(containCheckPoint.getValue())) {
            return new CheckPointResultDetail(
                    true,
                    "包含检查点，检查通过"
            );
        } else {
            return new CheckPointResultDetail(
                    false,
                    String.format("包含检查点，检查未通过，结果：%s 中，不包含值：%s", responseBody, containCheckPoint.getValue())
            );
        }
    }

    public CheckPointResultDetail noContainCheck(NoContainCheckPoint noContainCheckPoint, String responseBody) {
            if (responseBody.contains(noContainCheckPoint.getValue())) {
                return new CheckPointResultDetail(
                        false,
                        String.format("不包含检查点，检查未通过，结果：%s 中，包含值：%s", responseBody, noContainCheckPoint.getValue())
                );
            } else {
                return new CheckPointResultDetail(
                        true,
                        "不包含检查点，检查通过"
                );
            }
    }


    public CheckPointResultDetail nullCheck(String responseBody) {
        boolean isNull = false;
        if (StringUtils.isBlank(responseBody)) {
            isNull = true;
        } else {
            try {
                JSONObject jsonObject = JSON.parseObject(responseBody);
                isNull = jsonObject.isEmpty();
            } catch (JSONException ignored) {
            }
            try {
                JSONArray jsonArray = JSON.parseArray(responseBody);
                isNull = jsonArray.isEmpty();
            } catch (JSONException ignored) {
            }
        }
        if (isNull) {
            return new CheckPointResultDetail(
                    false,
                    String.format("不为空检查点，检查未通过，请求结果：%s", responseBody)
            );
        } else {
            return new CheckPointResultDetail(
                    true,
                    "不为空检查点，检查通过"
            );
        }
    }


    public CheckPointResultDetail exceptionCheck(HttpResponseDetail httpResponseDetail) {
        if (httpResponseDetail.getStatusCode().value() == HttpStatus.OK.value()) {
            return new CheckPointResultDetail(
                    true,
                    "异常检查点，检查通过"
            );
        } else {
            return new CheckPointResultDetail(
                    true,
                    String.format("异常检查点，检查未通过，Http请求错误，错误码：%d,请求结果：%s", httpResponseDetail.getStatusCode().value(), httpResponseDetail.getResponseBody())
            );
        }
    }





}
