package org.matrix.database.service;

import org.matrix.database.entity.Environment;
import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.database.vo.PageResult;

import java.util.List;

/**
 * <p>
 * 实例表，项目对应的环境实例，例如：实验室环境，开发环境等 服务类
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
public interface IEnvironmentService extends IService<Environment> {

    /**
     * 添加实例
     *
     * @param environment 实例
     * @return 影响行数
     */
    int insertEnvironment(Environment environment);

    /**
     * 修改实例
     *
     * @param environment 实例
     * @return 影响行数
     */
    int updateEnvironment(Environment environment);

    /**
     * 删除实例
     *
     * @param id 实例
     * @return 影响行数
     */
    int deleteEnvironment(Integer id);

    /**
     * 根据项目id查询动作
     *
     * @param projectId 项目id
     * @return 符合项目id的动作
     */
    List<Environment> findByProjectIdEnvironment(Integer projectId);

    /**
     * 分页查询
     *
     * @param pageResult 封装的分页
     * @return 分页后的数据
     */
    PageResult pageAll(PageResult pageResult);

}
