package org.matrix.database.vo;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

/**
 * @author mry
 */
public class CommonResult {

    /**
     * 成功返回结果
     *
     * @param data 获取的数据
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> success(T data, HttpHeaders headers) {
        return new ResponseEntity(new CommonResultObj(data), headers, HttpStatus.OK);
    }

    /**
     * 成功返回结果
     *
     * @param data    获取的数据
     * @param message 提示信息
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> success(T data, String message) {
        return ResponseEntity.ok(new CommonResultObj<>(data, message));
    }

    /**
     * 成功返回结果
     *
     * @param message 提示信息
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> success(String message) {
        return ResponseEntity.ok(new CommonResultObj<>(null, message));
    }

    /**
     * 成功返回结果
     *
     * @param data
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> success(T data) {
        return ResponseEntity.ok(new CommonResultObj<>(data));
    }

    /**
     * 成功返回结果
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> success() {
        return ResponseEntity.ok(new CommonResultObj<>());
    }

    /**
     * 失败返回结果
     *
     * @param data 获取的数据
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> failed(T data, HttpHeaders headers) {
        return new ResponseEntity(new CommonResultObj(data), headers, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    /**
     * 失败返回结果
     *
     * @param data    获取的数据
     * @param message 提示信息
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> failed(T data, String message) {
        return ResponseEntity.status(500).body(new CommonResultObj<>(data, message));
    }

    /**
     * 失败返回结果
     *
     * @param message 提示信息
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> failed(String message) {
        return ResponseEntity.status(500).body(new CommonResultObj<>(null, message));
    }

    /**
     * 失败返回结果
     *
     * @param data 获取的数据
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> failed(T data) {
        return ResponseEntity.status(500).body(new CommonResultObj<>(data));
    }

    /**
     * 失败返回结果
     */
    @SuppressWarnings(value = "all")
    public static <T> ResponseEntity<CommonResultObj<T>> failed() {
        return ResponseEntity.status(500).body(new CommonResultObj<>());
    }

}
