package org.matrix.actuators.sql;

import com.alibaba.fastjson.JSON;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.matrix.actuators.httpclient.HttpClientActuator;
import org.matrix.actuators.httpclient.HttpRequestDetail;
import org.matrix.actuators.httpclient.HttpResponseDetail;
import org.matrix.config.HttpRequestConfig;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest
class HttpClientActuatorTest {

    @Test
    void test(){
        HttpClientActuator httpClientActuator = new HttpClientActuator(
                new HttpRequestConfig(),
                1l,
                1l
        );
        String json = "{\n" +
                "    \"url\": \"http://127.0.0.1:8080/test/tableName\",\n" +
                "    \"method\": \"GET\",\n" +
                "    \"requestType\": \"QUERY\",\n" +
                "    \"requestBodies\": [\n" +
                "        {\n" +
                "            \"key\": \"tableName\",\n" +
                "            \"type\": \"TEXT\",\n" +
                "            \"value\": \"example\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";
        HttpRequestDetail httpRequestDetail = JSON.parseObject(json, HttpRequestDetail.class);
        HttpResponseDetail httpResponseDetail = httpClientActuator.sendHttpRequest(httpRequestDetail);
        System.out.println(httpResponseDetail);
    }

}
