package org.matrix.util;

import cn.hutool.script.ScriptUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.matrix.entity.checkPoint.*;
import org.matrix.entity.httpRequest.HttpResponseDetail;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;

import javax.script.ScriptEngine;
import javax.script.ScriptException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


/**
 * 数据检测点工具
 * todo 打印LOG
 *
 * @author Administrator
 */
public class CheckPointUtil {

    private String baseJs;

    CheckPointUtil(String path) {
        ClassPathResource cpr = new ClassPathResource(path);
        try {
            this.baseJs = IOUtils.toString(cpr.getInputStream(), StandardCharsets.UTF_8);
        } catch (IOException e) {
            //todo 抛出异常 初始JS加载失败
            e.printStackTrace();
        }
    }

    public void httpCheck(HttpResponseDetail httpResponseDetail, CheckPoint checkPoint) {
        CheckPointResult checkPointResult = new CheckPointResult();
        //根据checkPoint里的细节数据开始检测
        //异常检查点检测
        if (checkPoint.getUseExceptionCheck()) {
            checkPointResult.addCheckPointResultDetail(exceptionCheck(httpResponseDetail));
        }
        //异常检查点检测
        if (checkPoint.getUseNullCheck()) {
            checkPointResult.addCheckPointResultDetail(nullCheck(httpResponseDetail.getResponseBody()));
        }
        //包含检查点检测
        for (ContainCheckPoint containCheckPoint : checkPoint.getContainCheckPoints()) {
            checkPointResult.addCheckPointResultDetail(containCheck(containCheckPoint, httpResponseDetail.getResponseBody()));
        }
        //todo 数据库参数检测
        //JsonPath检查点检测
        if (checkPoint.getJsonPathCheckPoints().size() > 0) {
            Object jsonObject = Configuration.defaultConfiguration().jsonProvider().parse(httpResponseDetail.getResponseBody());
            for (JsonPathCheckPoint jsonPathCheckPoint : checkPoint.getJsonPathCheckPoints()) {
                checkPointResult.addCheckPointResultDetail(jsonPathCheck(jsonPathCheckPoint, jsonObject));
            }
        }
    }

    public CheckPointResultDetail jsonPathCheck(JsonPathCheckPoint jsonPathCheckPoint, Object jsonObject) {
        String expression;
        try {
            expression = completeJsonPathExpression(jsonPathCheckPoint, jsonObject);
        } catch (IllegalArgumentException e) {
            return new CheckPointResultDetail(
                    false,
                    String.format("JsonPath检查点，检查未通过，不能填写空的JsonPath,错误的jsonpath为：%s", jsonPathCheckPoint.getExpression())
            );
        } catch (PathNotFoundException e) {
            return new CheckPointResultDetail(
                    false,
                    String.format("JsonPath检查点，检查未通过，jsonpath取不到任何值，错误的path为：%s,http返回值为：  %s", e.getMessage().substring(e.getMessage().indexOf(":")), jsonObject.toString())
            );
        }
        try {
            ScriptEngine jsEngine = getScriptEngine();
            Object eval = jsEngine.eval(expression);
            if (eval instanceof Boolean){
                if ((Boolean) eval){
                    return new CheckPointResultDetail(
                            true,
                            String.format("JsonPath检查点，检查通过,表达式为：%s", expression)
                    );
                }else {
                    return new CheckPointResultDetail(
                            false,
                            String.format("JsonPath检查点，检查未通过,计算结果为false,错误的表达式为：%s", expression)
                    );
                }
            }else {
                return new CheckPointResultDetail(
                        false,
                        String.format("JsonPath检查点，检查未通过，JsonPath的返回值不是一个布尔类型,错误的表达式为：%s", expression)
                );
            }
        } catch (ScriptException e) {
            //todo 抛出异常初始化js引擎失败
            e.printStackTrace();
        }
        return new CheckPointResultDetail(
                false,
                "JsonPath检查点，检查未通过，空的表达式"
        );
    }

    public ScriptEngine getScriptEngine() throws ScriptException {
        ScriptEngine jsEngine = ScriptUtil.createJsEngine();
        jsEngine.eval(baseJs);
        return jsEngine;
    }

    public String completeJsonPathExpression(JsonPathCheckPoint jsonPathCheckPoint, Object jsonObject) {
        String result = jsonPathCheckPoint.getExpression();
        //todo 李迪凡 先将result中的动态变量都还原出来  （先后顺序不能乱）得先还原动态变量
        //将jsonPath都还原出来
        String regex = "(?=\\{)(.*?)(?<=})";
        Pattern pattern = Pattern.compile(regex);
        Matcher mat = pattern.matcher(result);
        while (mat.find()) {
            String group = mat.group();
            String read = JSON.toJSONString(JsonPath.read(jsonObject, group.substring(1, group.length() - 1)));
            result = mat.replaceAll(read);
        }
        return result;
    }

    public static void main(String[] args) {
        String json = "{\n" +
                "    \"school\": [\n" +
                "        {\n" +
                "            \"className\": \"一班\",\n" +
                "            \"student\":[\n" +
                "                \"一班的张三\",\"一班的李四\",\"一班的王五\",\"一班的赵六\",\"一班的田七\"\n" +
                "            ]\n" +
                "        },\n" +
                "        {\n" +
                "            \"className\": \"二班\",\n" +
                "            \"student\":[\n" +
                "                \"二班的张三\",\"二班的李四\",\"二班的王五\",\"二班的赵六\",\"二班的田七\"\n" +
                "            ]\n" +
                "        },\n" +
                "        {\n" +
                "            \"className\": \"三班\",\n" +
                "            \"student\":[\n" +
                "                \"三班的张三\",\"三班的李四\",\"三班的王五\",\"三班的赵六\",\"三班的田七\"\n" +
                "            ]\n" +
                "        }\n" +
                "    ]\n" +
                "}";

        Object jsonObject = Configuration.defaultConfiguration().jsonProvider().parse(json);
        CheckPointUtil checkPointUtil = new CheckPointUtil("baseJS.js");
        CheckPointResultDetail checkPointResultDetail = checkPointUtil.jsonPathCheck(new JsonPathCheckPoint(
                        "contains({$..className},\"一班\")"
                ),
                jsonObject);
        System.out.println(checkPointResultDetail);
    }

    public CheckPointResultDetail containCheck(ContainCheckPoint containCheckPoint, String responseBody) {
        if (containCheckPoint.getIsContain()) {
            if (responseBody.contains(containCheckPoint.getValue())) {
                return new CheckPointResultDetail(
                        true,
                        "包含检查点，检查通过"
                );
            } else {
                return new CheckPointResultDetail(
                        false,
                        String.format("包含检查点，检查未通过，结果：%s 中，不包含值：%s", responseBody, containCheckPoint.getValue())
                );
            }
        } else {
            if (responseBody.contains(containCheckPoint.getValue())) {
                return new CheckPointResultDetail(
                        false,
                        String.format("不包含检查点，检查未通过，结果：%s 中，包含值：%s", responseBody, containCheckPoint.getValue())
                );
            } else {
                return new CheckPointResultDetail(
                        true,
                        "不包含检查点，检查通过"
                );
            }
        }
    }


    public CheckPointResultDetail nullCheck(String responseBody) {
        boolean isNull = false;
        if (StringUtils.isBlank(responseBody)) {
            isNull = true;
        } else {
            try {
                JSONObject jsonObject = JSON.parseObject(responseBody);
                isNull = jsonObject.isEmpty();
            } catch (JSONException ignored) {
            }
            try {
                JSONArray jsonArray = JSON.parseArray(responseBody);
                isNull = jsonArray.isEmpty();
            } catch (JSONException ignored) {
            }
        }
        if (isNull) {
            return new CheckPointResultDetail(
                    false,
                    String.format("不为空检查点，检查未通过，请求结果：%s", responseBody)
            );
        } else {
            return new CheckPointResultDetail(
                    true,
                    "异常检查点，检查通过"
            );
        }
    }


    public CheckPointResultDetail exceptionCheck(HttpResponseDetail httpResponseDetail) {
        if (httpResponseDetail.getStatusCode() == HttpStatus.OK.value()) {
            return new CheckPointResultDetail(
                    true,
                    "异常检查点，检查通过"
            );
        } else {
            return new CheckPointResultDetail(
                    true,
                    String.format("异常检查点，检查未通过，Http请求错误，错误码：%d,请求结果：%s", httpResponseDetail.getStatusCode(), httpResponseDetail.getResponseBody())
            );
        }
    }

}
