package org.matrix.autotest.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.autotest.entity.Environment;

import java.util.List;

/**
 * <p>
 * 实例表，项目对应的环境实例，例如：实验室环境，开发环境等 服务类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
public interface EnvironmentService extends IService<Environment> {
    /**
     * 查询所有实例
     *
     * @return 查询到的所有实例
     */
    List<Environment> findAllEnvironment();

    /**
     * 根据id查询实例
     *
     * @param id 实例id
     * @return 实例
     */
    Environment findByIdEnvironment(Integer id);

    /**
     * 添加实例
     *
     * @param environment 实例
     * @return 影响行数
     */
    int insertEnvironment(Environment environment);

    /**
     * 修改实例
     *
     * @param environment 实例
     * @return 影响行数
     */
    int updateEnvironment(Environment environment);

    /**
     * 删除实例
     *
     * @param id 实例
     * @return 影响行数
     */
    int deleteEnvironment(Integer id);

}
