package org.matrix.autotest.service.Impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.autotest.dao.ActionMapper;
import org.matrix.autotest.entity.Action;
import org.matrix.autotest.service.ActionService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 动作 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@Service
public class ActionServiceImpl extends ServiceImpl<ActionMapper, Action> implements ActionService {

    private final ActionMapper actionMapper;

    public ActionServiceImpl(ActionMapper actionMapper) {
        this.actionMapper = actionMapper;
    }

    @Override
    public List<Action> findAllAction() {
        return actionMapper.selectList(null);
    }

    @Override
    public Action findByIdAction(Integer id) {
        return actionMapper.selectById(id);
    }

    @Override
    public int insertAction(Action action) {
        return actionMapper.insert(action);
    }

    @Override
    public int updateAction(Action action) {
        return actionMapper.updateById(action);
    }

    @Override
    public int deleteAction(Integer id) {
        return actionMapper.deleteById(id);
    }

    @Override
    public List<Action> findByProjectIdAction(Integer projectId) {
        QueryWrapper<Action> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        return actionMapper.selectList(queryWrapper);
    }

}
