package org.matrix.autotest.service.Impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.autotest.dao.DynamicVariableMapper;
import org.matrix.autotest.entity.DynamicVariable;
import org.matrix.autotest.service.DynamicVariableService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@Service
public class DynamicVariableServiceImpl extends ServiceImpl<DynamicVariableMapper, DynamicVariable> implements DynamicVariableService {

    private final DynamicVariableMapper dynamicVariableMapper;

    public DynamicVariableServiceImpl(DynamicVariableMapper dynamicVariableMapper) {
        this.dynamicVariableMapper = dynamicVariableMapper;
    }


    @Override
    public List<DynamicVariable> findAllDynamicVariable() {
        return dynamicVariableMapper.selectList(null);
    }

    @Override
    public DynamicVariable findByIdDynamicVariable(Integer id) {
        return dynamicVariableMapper.selectById(id);
    }

    @Override
    public int insertDynamicVariable(DynamicVariable dynamicVariable) {
        return dynamicVariableMapper.insert(dynamicVariable);
    }

    @Override
    public int updateDynamicVariable(DynamicVariable dynamicVariable) {
        return dynamicVariableMapper.updateById(dynamicVariable);
    }

    @Override
    public int deleteDynamicVariable(Integer id) {
        return dynamicVariableMapper.deleteById(id);
    }

}
