package org.matrix.autotest.service.Impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.autotest.dao.EnvironmentMapper;
import org.matrix.autotest.entity.Environment;
import org.matrix.autotest.service.EnvironmentService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 实例表，项目对应的环境实例，例如：实验室环境，开发环境等 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@Service
public class EnvironmentServiceImpl extends ServiceImpl<EnvironmentMapper, Environment> implements EnvironmentService {

    private final EnvironmentMapper environmentMapper;

    public EnvironmentServiceImpl(EnvironmentMapper environmentMapper) {
        this.environmentMapper = environmentMapper;
    }

    @Override
    public List<Environment> findAllEnvironment() {
        return environmentMapper.selectList(null);
    }

    @Override
    public Environment findByIdEnvironment(Integer id) {
        return environmentMapper.selectById(id);
    }

    @Override
    public int insertEnvironment(Environment environment) {
        return environmentMapper.insert(environment);
    }

    @Override
    public int updateEnvironment(Environment environment) {
        return environmentMapper.updateById(environment);
    }

    @Override
    public int deleteEnvironment(Integer id) {
        return environmentMapper.deleteById(id);
    }

}
