package org.matrix.autotest.service.Impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.autotest.dao.MoveMapper;
import org.matrix.autotest.entity.Move;
import org.matrix.autotest.service.MoveService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
@Service
public class MoveServiceImpl extends ServiceImpl<MoveMapper, Move> implements MoveService {

    private final MoveMapper moveMapper;

    public MoveServiceImpl(MoveMapper moveMapper) {
        this.moveMapper = moveMapper;
    }

    @Override
    public List<Move> findAllMove() {
        return moveMapper.selectList(null);
    }

    @Override
    public Move findByIdMove(Integer id) {
        return moveMapper.selectById(id);
    }

    @Override
    public int insertMove(Move move) {
        return moveMapper.insert(move);
    }

    @Override
    public int updateMove(Move move) {
        return moveMapper.updateById(move);
    }

    @Override
    public int deleteMove(Integer id) {
        return moveMapper.deleteById(id);
    }

}
