package org.matrix.autotest.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.autotest.entity.TestCase;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author mry
 * @since 2022-01-07
 */
public interface TestCaseService extends IService<TestCase> {
    /**
     * 查询所有用例
     *
     * @return 查询到的所有用例
     */
    List<TestCase> findAllTestCase();

    /**
     * 根据id查询用例
     *
     * @param id 用例Id
     * @return 用例
     */
    TestCase findByIdTestCase(Integer id);

    /**
     * 添加用例
     *
     * @param testCase 用例
     * @return 影响行数
     */
    int insertTestCase(TestCase testCase);

    /**
     * 修改用例
     *
     * @param testCase 用例
     * @return 影响行数
     */
    int updateTestCase(TestCase testCase);

    /**
     * 删除用例
     *
     * @param id 用例
     * @return 影响行数
     */
    int deleteTestCase(Integer id);

}
