package org.matrix.entity.httpRequest;

import org.springframework.lang.Nullable;

import java.util.HashMap;
import java.util.Map;

public enum HttpRequestType {

    QUERY,
    REST,
    FORM_DATA,
    X_WWW_FORM_URLENCODED,
    TEXT,
    JSON,
    XML,
    BINARY,
    NONE;

    private static final Map<String, HttpRequestType> mappings = new HashMap(16);

    private HttpRequestType() {
    }

    @Nullable
    public static HttpRequestType resolve(@Nullable String method) {
        return method != null ? mappings.get(method) : null;
    }

    public boolean matches(String method) {
        return this.name().equals(method);
    }

    static {
        HttpRequestType[] var0 = values();
        int var1 = var0.length;
        for(int var2 = 0; var2 < var1; ++var2) {
            HttpRequestType httpMethod = var0[var2];
            mappings.put(httpMethod.name(), httpMethod);
        }

    }
}
