package org.matrix.testNg;

import org.testng.ITestResult;
import org.testng.annotations.*;

public class TestPigeon {

    String sql;
    String env;

    @Parameters({"sql", "env"})
    @BeforeClass
    public void beforeClass(String sql, String env) {
        this.sql = sql;
        this.env = env;
    }

    /**
     * XML中的SQL决定了执行什么用例, 执行多少条用例, SQL的搜索结果为需要测试的测试用例
     * @DataProvider 返回值二维数组
     */
    @DataProvider(name = "testData")
    private Object[][] getData() {
        return DataProvider_forDB.getDb(TestConfig.DB_IP, TestConfig.DB_PORT,
                TestConfig.DB_BASE_NAME,TestConfig.DB_USERNAME, TestConfig.DB_PASSWORD, sql);
    }

    @Test(dataProvider = "testData")
    public void test(String s1, String s2, String s3) {
//        System.out.println(env);
//        System.out.println(s1 + ":" + s2 + ":" + s3);
    }

    @AfterMethod
    public void afterMethod(ITestResult result, Object[] objs) {
        System.out.println("正在运行的方法:" + result.getName());
    }

}
