package org.matrix.swaggerData;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RestController
@RequestMapping("/swaggers")
@CrossOrigin
public class SwaggerController {

    public String loadJson(String url) {
        BufferedReader reader = null;
        StringBuilder json = new StringBuilder();
        try {
            URL urlObject = new URL(url);
            URLConnection uc = urlObject.openConnection();
            InputStream inputStream = uc.getInputStream();
            reader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            String inputLine = null;
            while ((inputLine = reader.readLine()) != null) {
                json.append(inputLine);
            }
            reader.close();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return json.toString();
    }

    @GetMapping
    public Object parameter(String url) {
        List<String> list = new ArrayList();
        String json = loadJson(url);  //获得json字符串
        JSONObject swaggerJson = JSONObject.parseObject(json);
        Object host = swaggerJson.get("host");     //localhost:8765
        Object basePath = swaggerJson.get("basePath");     //"/"
        Object paths = swaggerJson.get("paths");
        //将paths转成map集合
        Map<String, String> pathsMaps = (Map<String, String>) paths;
        //获取key
        Set<String> methodUrls = pathsMaps.keySet();
        //循环获取每个methodUrl
        for (String methodUrl : methodUrls) {
            //将paths转成JSON
            JSONObject objPaths = (JSONObject) paths;
            //通过JSON获取到methodUrl,用来获取methodUrl内部的信息
            Object objMethodUrls = objPaths.get(methodUrl);
            JSONObject objUrlsJson = (JSONObject) objMethodUrls;
            Map<String, String> objMethodUrlsMaps = (Map<String, String>) objMethodUrls;
            Set<String> requests = objMethodUrlsMaps.keySet();
            for (String request : requests) {
                Object objRequest = objUrlsJson.get(request);//拿到请求内部的信息
                Map<String, String> objRequestMaps = (Map<String, String>) objRequest;
                Object parameters = objRequestMaps.get("parameters");
                List<String> parameterAllList = new ArrayList<>();
                if (parameters != null) {
                    List<String> parameterLists = (List<String>) parameters;
                    for (Object parameterList : parameterLists) {
                        Map<String, String> parameterMaps = (Map<String, String>) parameterList;
                        String name = parameterMaps.get("name");
                        String type = parameterMaps.get("type");
                        String in = parameterMaps.get("in");
                        if (name == null) {
                            name = "";
                        }
                        if (type == null) {
                            type = "";
                        }
                        if (in == null) {
                            in = "";
                        }
                        parameterAllList.add("name=" + name + " type=" + type + " in=" + in);
                    }
                }
                list.add("{host=" + host + ", basePath=" + basePath + ", request=" + request + ", methodUrl=" + methodUrl + ", parameters=" + parameterAllList + "}");
            }
        }
        Object swagger = JSON.toJSON(list);
        return swagger;
    }

}
