package org.matrix.database.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Select;
import org.matrix.database.entity.TestJob;
import org.matrix.database.vo.TestJobVo;

/**
 * @author mry
 */
public interface TestJobMapper extends BaseMapper<TestJob> {

    /**
     * 分页查询TestJob
     * @param page 分页信息
     * @param name 测试任务名（查询条件）
     * @return 带有分页的测试任务列表
     */
    @Select("<script>" +
            "SELECT\n" +
            "\tktj.id,\n" +
            "\tktj.`name`,\n" +
            "\tktj.sql_statement,\n" +
            "\tktj.remark,\n" +
            "\t`status` \n" +
            "FROM\n" +
            "\t`kt_test_job` ktj\n" +
            "\tLEFT JOIN ( SELECT job_id, unique_key FROM kt_execution_history WHERE id IN ( SELECT max( id ) FROM kt_execution_history WHERE job_id != - 1 GROUP BY job_id ) ) keh ON ktj.id = keh.job_id\n" +
            "\tLEFT JOIN ( SELECT unique_key, IF ( MIN( `status` )= 0, 0, MAX( `status` )) `status` FROM kt_execution_history GROUP BY unique_key ) us ON us.unique_key = keh.unique_key" +
            "<where>" +
            "<if test=\"name!=null and name!=''\">" +
            "and ktj.`name` like concat('%',#{name},'%')" +
            "</if>" +
            "</where>" +
            "</script>")
    IPage<TestJobVo> pageTestJob(IPage<TestJob> page,String name);
}
