package org.matrix.testNg.web.report;

import org.matrix.testNg.web.entity.DataBean;
import org.matrix.testNg.web.entity.DataBeans;
import org.matrix.testNg.web.entity.DataMove;
import org.matrix.testNg.web.vo.DataBeansMoveVo;
import org.matrix.util.ReporterUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author MRY
 */
public class ReporterDataJob {
    /**
     * 模板公共部分
     *
     * @return 补全了的所有报告信息
     */
    public DataBean testDataBean() {
        return ReporterUtils.jobMap.get("job").getDataBean();
    }

    /**
     * 动作部分
     */
    public List<DataMove> testDataBeanMove() {
        List<DataMove> dataMoveList = new ArrayList<>();
        List<DataBeansMoveVo> dataBeansMoveVos = ReporterUtils.jobMap.get("job").getDataBeansMove();
        for (DataBeansMoveVo dataBeansMoveVo : dataBeansMoveVos) {
            DataMove dataMove = dataBeansMoveVo.getDataMove();
            dataMoveList.add(dataMove);
        }
        return dataMoveList;
    }

    /**
     * 模板的细节部分
     *
     * @return 报告中细节部分的信息
     */
    public List<DataBeans> testDataBeans() {
        List<DataBeans> dataBeansList = null;
        List<DataBeansMoveVo> dataBeansMoveVos = ReporterUtils.jobMap.get("job").getDataBeansMove();
        for (DataBeansMoveVo dataBeansMoveVo : dataBeansMoveVos) {
            dataBeansList = dataBeansMoveVo.getDataBeansList();
        }
        return dataBeansList;
    }
}
