package org.matrix.actuators.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.matrix.actuators.httpclient.HttpClientActuator;
import org.matrix.actuators.httpclient.HttpRequestDetail;
import org.matrix.actuators.httpclient.HttpResponseDetail;
import org.matrix.config.HttpRequestConfig;
import org.matrix.database.entity.ExecutionRecord;
import org.matrix.database.service.IExecutionRecordService;
import org.matrix.exception.GlobalException;
import org.matrix.socket.enums.TestExecuteType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import static java.util.stream.Collectors.groupingBy;

@RunWith(SpringRunner.class)
@SpringBootTest
class HttpClientActuatorTest {

    @Autowired
    HttpClientActuator httpClientActuator;

    @Autowired
    IExecutionRecordService executionRecordService;

    @Test
    void test(){

        String json = "{\n" +
                "    \"url\": \"http://127.0.0.1:8080/test/tableName\",\n" +
                "    \"method\": \"GET\",\n" +
                "    \"requestType\": \"QUERY\",\n" +
                "    \"requestBodies\": [\n" +
                "        {\n" +
                "            \"key\": \"tableName\",\n" +
                "            \"type\": \"TEXT\",\n" +
                "            \"value\": \"example\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";
         HttpRequestDetail httpRequestDetail1 = JSON.parseObject(json, HttpRequestDetail.class);
        HttpRequestDetail httpRequestDetail = JSON.parseObject(json, HttpRequestDetail.class);
        HttpResponseDetail httpResponseDetail = httpClientActuator.sendHttpRequest(httpRequestDetail,1l,1l);
        System.out.println(httpResponseDetail);
    }
    @Test
    void test2(){
        List<ExecutionRecord> results = getExecutionRecords(1L, null, null, "e9e0a9cd-df63-4fea-9992-68d31c8b2160", null);
        Map<Long, Map<Long, Map<Long, List<ExecutionRecord>>>> map = results.stream().collect(
                groupingBy(ExecutionRecord::getTestJobId,
                        groupingBy(ExecutionRecord::getTestCaseId,
                                groupingBy(ExecutionRecord::getTestDataId))));
        System.out.println("1");
    }

    List<ExecutionRecord> getExecutionRecords(Long userId, Long testDataId, Long testCaseId, String uniqueKey, TestExecuteType type) {
        List<ExecutionRecord> results = Optional.of(executionRecordService.list(
                Wrappers.lambdaQuery(ExecutionRecord.class)
                        .eq(userId != null, ExecutionRecord::getUserId, userId)
                        .eq(testDataId != null, ExecutionRecord::getTestDataId, testDataId)
                        .eq(testCaseId != null, ExecutionRecord::getTestCaseId, testCaseId)
                        .eq(StringUtils.hasLength(uniqueKey), ExecutionRecord::getUniqueKey, uniqueKey)
                        .eq(type != null, ExecutionRecord::getType, type)
        )).orElseThrow(() -> new GlobalException("xxx"));
        return results;
    }


    void putValueToNext(ExecutionRecord record, JSONObject resultJson, JSONArray jsonArray, int num){
        if (num==4){
            jsonArray.add(record.getLog());
        }else {
            if (num==1){
                JSONObject jsonObject = resultJson.getJSONObject(record.getTestJobId() + "");
                if (jsonObject!=null){
                    putValueToNext(record,jsonObject,jsonArray,2);
                }else {
                    JSONObject newJsonObject = new JSONObject();
                    resultJson.put(record.getTestJobId() + "",newJsonObject);
                    putValueToNext(record,newJsonObject,jsonArray,2);
                }
            }
            if (num==2){
                JSONObject jsonObject = resultJson.getJSONObject(record.getTestCaseId() + "");
                if (jsonObject!=null){
                    putValueToNext(record,jsonObject,jsonArray,3);
                }else {
                    JSONObject newJsonObject = new JSONObject();
                    resultJson.put(record.getTestCaseId() + "",newJsonObject);
                    putValueToNext(record,newJsonObject,jsonArray,3);
                }
            }
            if (num==3){
                JSONObject jsonObject = resultJson.getJSONObject(record.getTestDataId() + "");
                if (jsonObject!=null){
                    putValueToNext(record,jsonObject,jsonArray,4);
                }else {
                    JSONArray newJsonArray = new JSONArray();
                    resultJson.put(record.getTestDataId() + "",newJsonArray);
                    putValueToNext(record,null,jsonArray,4);
                }
            }
        }
    }


}
