package org.matrix.database.service;

import com.baomidou.mybatisplus.extension.service.IService;
import org.matrix.database.entity.TestCase;
import org.matrix.database.vo.PageResult;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
public interface ITestCaseService extends IService<TestCase> {

    /**
     * 添加用例
     *
     * @param testCase 用例
     * @return 影响行数
     */
    int insertTestCase(TestCase testCase);

    /**
     * 修改用例
     *
     * @param testCase 用例
     * @return 影响行数
     */
    int updateTestCase(TestCase testCase);

    /**
     * 删除用例
     *
     * @param id 用例
     * @return 影响行数
     */
    int deleteTestCase(Integer id);

    /**
     * 根据项目id查询动作
     *
     * @param projectId 项目id
     * @return 符合项目id的动作
     */
    List<TestCase> findByProjectIdTestCase(Integer projectId);

    /**
     * 分页查询
     *
     * @param pageResult 封装的分页
     * @return 分页后的数据
     */
    PageResult pageAll(PageResult pageResult);

}
