package org.matrix.database.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.matrix.database.entity.Connect;
import org.matrix.database.mapper.ConnectMapper;
import org.matrix.database.service.IConnectService;
import org.matrix.database.vo.PageResult;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author matrix
 * @since 2022-01-15
 */
@Service
public class ConnectServiceImpl extends ServiceImpl<ConnectMapper, Connect> implements IConnectService {

    private final ConnectMapper connectMapper;

    public ConnectServiceImpl(ConnectMapper connectMapper) {
        this.connectMapper = connectMapper;
    }

    @Override
    public int insertConnect(Connect connect) {
        return connectMapper.insert(connect);
    }

    @Override
    public int updateConnect(Connect connect) {
        return connectMapper.updateById(connect);
    }

    @Override
    public int deleteConnect(Integer id) {
        return connectMapper.deleteById(id);
    }

    @Override
    public PageResult pageAll(PageResult pageResult) {
        IPage ipage = new Page(pageResult.getPageNum(), pageResult.getPageSize());
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean flage = StringUtils.hasLength(pageResult.getQuery());
        queryWrapper.like(flage, "name", pageResult.getQuery());
        //执行分页查询，返回值依然是分页的对象
        ipage = connectMapper.selectPage(ipage, queryWrapper);
        long total = ipage.getTotal();
        List<Connect> rows = ipage.getRecords();
        //回传5个参数 total/分页后的数据
        return pageResult.setTotal(total).setRows(rows);
    }

}
