package org.matrix.actuators.sql;

import com.alibaba.fastjson.JSON;
import org.checkerframework.checker.units.qual.A;
import org.junit.jupiter.api.Test;
import org.junit.runner.RunWith;
import org.matrix.actuators.httpclient.HttpClientActuator;
import org.matrix.actuators.httpclient.HttpRequestDetail;
import org.matrix.actuators.httpclient.HttpResponseDetail;
import org.matrix.actuators.usecase.CaseActuator;
import org.matrix.actuators.usecase.TestCaseExecuteResult;
import org.matrix.config.HttpRequestConfig;
import org.matrix.database.entity.TestCase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest
public class CaseActuatorTest {


    @Test
    public void test(){
        CaseActuator httpClientActuator = new CaseActuator(
                1l,
                1l
        );
        String json = "{\n" +
                "    \"url\":\"http://127.0.0.1:13245/test/sayHelloJson\",\n" +
                "    \"method\":\"POST\",\n" +
                "    \"requestType\":\"JSON\",\n" +
                "    \"stringValue\":\"{\\\"name\\\":\\\"${componentName}[0]\\\"}\",\n" +
                "    \"headers\":[\n" +
                "        {\n" +
                "            \"name\":\"cookie\",\n" +
                "            \"value\":\"123456\"\n" +
                "        }\n" +
                "    ]\n" +
                "}";
        TestCase testCase = new TestCase();
        testCase.setName("name");
        testCase.setType(1);
        testCase.setDetail(json);
        testCase.setAbnormalCheckpoint(1);
        testCase.setContainCheckpoint("");

        TestCaseExecuteResult testCaseExecuteResult = httpClientActuator.executeTestCase(testCase);
        System.out.println(testCaseExecuteResult);


    }

}
