package org.matrix.autotest.swaggerData;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author mry
 */
@RestController
@RequestMapping("/swaggers")
@CrossOrigin
@Api(tags = "Swagger接口读取与解析")
public class SwaggerController {

    public String loadJson(String url) {
        BufferedReader reader;
        StringBuilder json = new StringBuilder();
        try {
            URL urlObject = new URL(url);
            URLConnection uc = urlObject.openConnection();
            InputStream inputStream = uc.getInputStream();
            reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            String inputLine;
            while ((inputLine = reader.readLine()) != null) {
                json.append(inputLine);
            }
            reader.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return json.toString();
    }

    @GetMapping
    public Object parameter(String url) {
        @SuppressWarnings(value = "all")
        List<String> list = new ArrayList();
        //获得json字符串
        String json = loadJson(url);
        JSONObject swaggerJson = JSONObject.parseObject(json);
        //localhost:8765
        Object host = swaggerJson.get("host");
        //"/"
        Object basePath = swaggerJson.get("basePath");
        Object paths = swaggerJson.get("paths");
        //将paths转成map集合
        @SuppressWarnings(value = "unchecked")
        Map<String, String> pathsMaps = (Map<String, String>) paths;
        //获取key
        Set<String> methodUrls = pathsMaps.keySet();
        //循环获取每个methodUrl
        for (String methodUrl : methodUrls) {
            //将paths转成JSON
            JSONObject objPaths = (JSONObject) paths;
            //通过JSON获取到methodUrl,用来获取methodUrl内部的信息
            Object objMethodUrls = objPaths.get(methodUrl);
            JSONObject objUrlsJson = (JSONObject) objMethodUrls;
            @SuppressWarnings(value = "unchecked")
            Map<String, String> objMethodUrlsMaps = (Map<String, String>) objMethodUrls;
            Set<String> requests = objMethodUrlsMaps.keySet();
            for (String request : requests) {
                //拿到请求内部的信息
                Object objRequest = objUrlsJson.get(request);
                @SuppressWarnings(value = "unchecked")
                Map<String, String> objRequestMaps = (Map<String, String>) objRequest;
                Object parameters = objRequestMaps.get("parameters");
                List<String> parameterAllList = new ArrayList<>();
                if (parameters != null) {
                    @SuppressWarnings(value = "all")
                    List<String> parameterLists = (List<String>) parameters;
                    for (Object parameterList : parameterLists) {
                        @SuppressWarnings(value = "unchecked")
                        Map<String, String> parameterMaps = (Map<String, String>) parameterList;
                        String name = parameterMaps.get("name");
                        String type = parameterMaps.get("type");
                        String in = parameterMaps.get("in");
                        if (name == null) {
                            name = "";
                        }
                        if (type == null) {
                            type = "";
                        }
                        if (in == null) {
                            in = "";
                        }
                        parameterAllList.add("name=" + name + " type=" + type + " in=" + in);
                    }
                }
                list.add("{host=" + host + ", basePath=" + basePath + ", request=" + request + ", methodUrl=" + methodUrl + ", parameters=" + parameterAllList + "}");
            }
        }
        return JSON.toJSON(list);
    }

}
