package org.matrix.actuators.httpclient;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.matrix.actuators.usecase.BaseTestCaseResponseDetail;
import org.springframework.http.HttpStatus;

/**
 * @author huangxiahao
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class HttpResponseDetail extends BaseTestCaseResponseDetail {

    @ApiModelProperty("HttpClient响应体")
    private CloseableHttpResponse response;

    @ApiModelProperty("响应的内容，已转换为字符串")
    private String responseBody = "error request";

    @ApiModelProperty("响应状态,例如:200、401、500")
    private HttpStatus statusCode = HttpStatus.INTERNAL_SERVER_ERROR;

    @ApiModelProperty("响应时间,单位为 ms ")
    private Long responseTime = 0l;


}
